/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Id: TCPConfigDlg.h 2823 2011-08-08 16:26:18Z Robert $
   Last Modification:
    $Author: Robert $
    $Date: 2011-08-08 18:26:18 +0200 (Mo, 08 Aug 2011) $
    $Revision: 2823 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: no
     WinCE        : no
 
   Description:
     Default Dialog

   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
     2         27.11.09    SS       Review
     1         28.07.09    SS       initial version
 
**************************************************************************************/

/*****************************************************************************/
/*! \file TCPConfigDlg.h
*   Configuration dialog for the TCP connector                               */
/*****************************************************************************/

/* prevent multiple inclusion */
#pragma once

#include "TCPConfig.h"

/*****************************************************************************/
/*! \addtogroup netX_CONNECTOR_TCP netX TCP Connector                        */
/*! \{                                                                       */
/*****************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \class CTCPConfigDlg
/// Configuration Dialog for TCP Connector
///////////////////////////////////////////////////////////////////////////////////////////
class CTCPConfigDlg
{
public:

  static CTCPConfigDlg*  GetInstance       ( void);

  HWND                   Create            ( HWND        hWndParent,
                                             const char* szConfig = NULL);

  HWND                   GetWindowHandle   ( void) { return m_hDialogWnd;}

  long                   GetConfiguration  ( CString& csRet);
  long                   SetConfiguration  ( const char* szConfig);

  void                   Destroy           ( void);

protected:

  void                    OnBtnClickedNew       ( void);
  void                    OnBtnClickedRemove    ( void);

  void                    ReadFromDialogItems   ( NX_CONF_KEY_SCOPE_E eKeyScope, 
                                                  CONFIGKEY_MAP&      cmKeyMap);

  void                    WriteToDialogItems    ( NX_CONF_KEY_SCOPE_E eKeyScope,
                                                  CONFIGKEY_MAP&      cmKeyMap); 

  void                    InitUpDownControl     ( void);
  void                    PopulateComboBoxes    ( void);
  void                    SetIPAdressCounter    ( const char* szIntfName);

  void                    SetLayerDlgItemState      ( void);
  void                    SetInterfaceDlgItemState  ( void);
  void                    ShowSelInterfaceConfig    ( void);
  void                    ShowLayerConfig           ( void);

  CString                 GetSelInterfaceName   ( void);

         INT_PTR CALLBACK DialogProc            ( HWND hDlg, 
                                                  UINT message, 
                                                  WPARAM wParam, 
                                                  LPARAM lParam);

  static INT_PTR CALLBACK DialogProcStatic      ( HWND hDlg, 
                                                  UINT message, 
                                                  WPARAM wParam, 
                                                  LPARAM lParam);

  CTCPConfig        m_cTCPConfig;       /*!< Configuration object holding dialog config */

  HWND              m_hDialogWnd;       /*!< Window handle of the default dialog        */
  
private:
  // Constructor
  CTCPConfigDlg();
  // Destructor
  ~CTCPConfigDlg();
  // Copy constructor
  CTCPConfigDlg(const CTCPConfigDlg& cTCPConfigDlg);
  
  
  static CTCPConfigDlg* s_cInstance;    /*!< Pointer to single object instance          */
};

/*****************************************************************************/
/*! \}                                                                       */
/*****************************************************************************/